/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuilding
implements IBuildingWorker {
    public static final ISettingKey<BoolSetting> BREEDING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "breeding"));
    private HiringMode hiringMode = HiringMode.DEFAULT;
    private String jobDisplayName = "";

    public AbstractBuildingWorker(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (ICitizenData data : this.getAssignedCitizen()) {
            for (IRequest<?> request : this.getOpenRequests(data.getId())) {
                for (ItemStack deliveryStack : request.getDeliveries()) {
                    if (!deliveryStack.func_185136_b(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        this.markDirty();
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        if (this.keepFood()) {
            toKeep.put(stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack), (Tuple<Integer, Boolean>)new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        }
        for (IHasRequiredItemsModule module : this.getModules(IHasRequiredItemsModule.class)) {
            toKeep.putAll(module.getRequiredItemsAndAmount());
        }
        return toKeep;
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getPrimarySkill();
    }

    @Override
    public List<IItemHandler> getHandlers() {
        IColony colony = this.getColony();
        if (this.getAssignedEntities().isEmpty() || colony == null || colony.getWorld() == null) {
            return Collections.emptyList();
        }
        HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
        for (ICitizenData workerEntity : this.getAssignedCitizen()) {
            handlers.add(workerEntity.getInventory());
        }
        TileEntity entity = colony.getWorld().func_175625_s(this.getID());
        if (entity != null) {
            LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            handler.ifPresent(handlers::add);
        }
        return ImmutableList.copyOf(handlers);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            citizen.getWorkBuilding().removeCitizen(citizen);
        }
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Unable to assign citizen:" + citizen.getName() + " to building:" + this.getSchematicName() + " jobname:" + this.getJobName());
            return false;
        }
        if (citizen != null) {
            citizen.setWorkBuilding(this);
            citizen.getJob().onLevelUp();
            this.colony.getProgressManager().progressEmploy(this.colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getJob() != null).collect(Collectors.toList()).size());
        }
        this.updateWorkerAvailableForRecipes();
        return true;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("worker")) {
            try {
                ListNBT workersTagList = compound.func_150295_c("worker", 10);
                for (int i = 0; i < workersTagList.size(); ++i) {
                    ICitizenData data = workersTagList.func_150305_b(i).func_150296_c().contains("id") ? this.getColony().getCitizenManager().getCivilian(workersTagList.func_150305_b(i).func_74762_e("id")) : (workersTagList.func_150305_b(i).func_150296_c().contains("workerId") ? this.getColony().getCitizenManager().getCivilian(workersTagList.func_150305_b(i).func_74762_e("workerId")) : null);
                    if (data == null) continue;
                    this.assignCitizen(data);
                }
            }
            catch (Exception e) {
                Log.getLogger().warn("Warning: Updating data structures:", (Throwable)e);
                ICitizenData worker = this.getColony().getCitizenManager().getCivilian(compound.func_74762_e("worker"));
                this.assignCitizen(worker);
            }
        }
        this.hiringMode = HiringMode.values()[compound.func_74762_e("buildingHiringMode")];
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT workersTagList = new ListNBT();
        for (ICitizenData data : this.getAssignedCitizen()) {
            if (data == null) continue;
            CompoundNBT idCompound = new CompoundNBT();
            idCompound.func_74768_a("workerId", data.getId());
            workersTagList.add((Object)idCompound);
        }
        compound.func_218657_a("worker", (INBT)workersTagList);
        compound.func_74768_a("buildingHiringMode", this.hiringMode.ordinal());
        return compound;
    }

    private void updateWorkerAvailableForRecipes() {
        for (AbstractCraftingBuildingModule module : this.getModules(AbstractCraftingBuildingModule.class)) {
            module.updateWorkerAvailableForRecipes();
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        ICitizenData joblessCitizen;
        super.onColonyTick(colony);
        for (ICraftingBuildingModule module : this.getModules(ICraftingBuildingModule.class)) {
            module.checkForWorkerSpecificRecipes();
        }
        if (!this.isFull() && (this.getBuildingLevel() > 0 && this.isBuilt() || this instanceof BuildingBuilder) && (this.hiringMode == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.hiringMode == HiringMode.AUTO) && (joblessCitizen = this.getColony().getCitizenManager().getJoblessCitizen()) != null) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setWorkBuilding(null);
            this.cancelAllRequestsOfCitizen(citizen);
            citizen.setVisibleStatus(null);
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData data : this.getAssignedCitizen()) {
            buf.writeInt(data == null ? 0 : data.getId());
        }
        buf.writeInt(this.hiringMode.ordinal());
        buf.func_180714_a(this.getJobName());
        buf.writeInt(this.getMaxInhabitants());
        buf.writeInt(this.getPrimarySkill().ordinal());
        buf.writeInt(this.getSecondarySkill().ordinal());
        buf.writeInt(this.getMaxInhabitants());
        buf.func_180714_a(this.getJobDisplayName());
    }

    @Override
    public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return 32;
        }
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return this.getBuildingLevel() - 0;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return this.getBuildingLevel() >= this.getMaxBuildingLevel();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new IRequestResolver[]{new BuildingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new PrivateWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new PrivateWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN))});
        for (ICreatesResolversModule module : this.getModules(ICreatesResolversModule.class)) {
            builder.addAll(module.createResolvers());
        }
        return builder.build();
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
        super.onBuildingMove(oldBuilding);
        List<ICitizenData> workers = oldBuilding.getAssignedCitizen();
        for (ICitizenData citizen : workers) {
            citizen.setWorkBuilding(null);
            citizen.setWorkBuilding(this);
            this.assignCitizen(citizen);
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        return stack.func_77973_b().func_219967_s().func_221466_a() >= this.getBuildingLevel();
    }

    public String getJobDisplayName() {
        if (this.jobDisplayName.isEmpty()) {
            this.jobDisplayName = this.createJob(null).getName();
        }
        return this.jobDisplayName;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public <T extends ISetting> T getSetting(@NotNull ISettingKey<T> key) {
        return this.getFirstModuleOccurance(ISettingsModule.class).getSetting(key);
    }

    public ICraftingBuildingModule getCraftingModuleForRecipe(IToken<?> token) {
        for (ICraftingBuildingModule module : this.getModules(ICraftingBuildingModule.class)) {
            if (!module.holdsRecipe(token)) continue;
            return module;
        }
        return null;
    }
}

